package kochModel.visitor;

import lrs.*;
import kochModel.*;
import java.awt.Graphics;
import fp.*;

public class PaintParentVisitor implements IKochVisitor<Object, Graphics> {
  
  public static final PaintParentVisitor Singleton = new PaintParentVisitor();
  
  private PaintParentVisitor() {}
  
  private  IMapAlgo<Koch, Graphics> _mapAlgo = new IMapAlgo<Koch, Graphics>() {
    public boolean apply(Koch host, Graphics... g) {
      host.execute(PaintParentVisitor.this, g);
      return true;
    }
    public void noApply(Graphics... g) {
    }
  };
  
  public Object baseCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    return null;
  }
  
  public Object inductCase(Koch host, Graphics... g) {
    paint(host, g[0]);
    host.map(_mapAlgo, g);
    return null;
  }
    
  private void paint(Koch host, Graphics g) {
    g.drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
               (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    
  }
}